<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
		<!-- BEGIN PAGE TITLE & BREADCRUMB-->
		<h3 class="page-title">
			Stats
		</h3>
		<!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->

<div class="box">
	<div class="box-body">
		<div class="row">
			<div class="col-sm-3 text-center">
                <img src="//api.webthumbnail.org/?width=400&height=300&screen=1366&url=<?php echo urlencode($link['Link']['long_url']); ?>" alt="<?php echo h($link['Link']['title']); ?>" title="<?php echo h($link['Link']['title']); ?>">
            </div>
            <div class="col-sm-7">
                <h3><?php echo $this->MightyLink->favicon($link[ 'Link' ][ 'long_url' ]); ?> <?php echo $this->Html->link($link['Link']['title'], $link['Link']['long_url']); ?></h3>
                <p><small><?php echo $this->Text->autoLinkUrls($link['Link']['long_url'], array('class' => 'text-muted')); ?></small></p>
                <p><?php echo h($link['Link']['description']); ?></p>
            </div>
            <div class="col-sm-2 text-center">
                <img alt="QR code" src="//chart.googleapis.com/chart?cht=qr&amp;chs=100x100&amp;choe=UTF-8&amp;chld=H|0&amp;chl=<?php echo urlencode($this->Html->url('/'.$link['Link']['alias'], true)); ?>" title="">
            </div>
        </div>
    </div>
</div>



<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">

        <!-- Info box -->
        <div class="box box-info">
            <div class="box-header">
                <i class="glyphicon glyphicon-stats"></i> <h3 class="box-title">Clicks on last 30 days</h3>
            </div>
            <div class="box-body">
                <div class="chart" id="last-month-hits" style="position: relative; height: 300px; width: 100%;"></div>
            </div><!-- /.box-body -->
        </div><!-- /.box -->

        <hr>

        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Countries</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-8">
                        <div id="countries_geochart" style="position: relative; height: 300px; width: 100%;"></div>
                    </div>
                    <div class="col-sm-4" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($countries as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-sm-4">
                <div class="box box-info">
                    <div class="box-header">
                        <h3 class="box-title">Continents</h3>
                    </div>
                    <div class="box-body" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($continents as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="box box-info">
                    <div class="box-header">
                        <h3 class="box-title">States</h3>
                    </div>
                    <div class="box-body" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($states as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="box box-info">
                    <div class="box-header">
                        <h3 class="box-title">Cities</h3>
                    </div>
                    <div class="box-body" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($cities as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Referrers</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-8">
                        <div id="referrers_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                    </div>
                    <div class="col-sm-4" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Domain</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($referrers as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <hr>

        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Browsers</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-8">
                        <div id="browsers_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                    </div>
                    <div class="col-sm-4" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($browsers as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Platforms</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-8">
                        <div id="platforms_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                    </div>
                    <div class="col-sm-4" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($platforms as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <hr>
        
        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Languages</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-8">
                        <div id="languages_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                    </div>
                    <div class="col-sm-4" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($languages as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <hr>

        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Devices</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-8">
                        <div id="devices_donut" style="position: relative; height: 300px; width: 100%;"></div>
                    </div>
                    <div class="col-sm-4" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Domain</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($devices as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <hr>

        <div class="row">
            <div class="col-sm-6">
                <div class="box box-success">
                    <div class="box-header">
                        <h3 class="box-title">Mobile Device Brands</h3>
                    </div>
                    <div class="box-body" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($brands as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="box box-success">
                    <div class="box-header">
                        <h3 class="box-title">Mobile Device Names</h3>
                    </div>
                    <div class="box-body" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($device_names as $key => $value) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $key;
                                    echo '</td>';
                                    echo '<td>';
                                    echo $value;
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($key, $value);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        
    </div>
</div>
<!-- END PAGE CONTENT-->


<script>

    jQuery(document).ready(function () {
        new Morris.Bar({
            element: 'last-month-hits',
            resize: true,
            data: [
<?php
$last30days = array();
for ($i = 30; $i > 0; $i--) {
    $last30days[date('d-m-Y', strtotime('-' . $i . ' days'))] = 0;
}

foreach ($linksStats as $date => $count) {
    if (empty($count)) {
        $count = 0;
    }
    $last30days[$date] = $count;
}

foreach ($last30days as $key => $value) {
    $date = date("Y-m-d", strtotime($key));
    echo '{date: "' . $date . '", clicks: ' . $value . '},';
}
unset($key, $value);
?>
            ],
            xkey: 'date',
            xLabels: 'day',
            ykeys: ['clicks'],
            labels: ['Clicks'],
            lineWidth: 2,
            hideHover: 'auto',
            smooth: false
        });


        /**
         * Browsers
         */


        new Morris.Bar({
            element: 'browsers_barchart',
            resize: true,
            data: [
<?php
foreach ($browsers as $key => $value) {
    echo '{browser: "' . $key . '", clicks: ' . $value . '},';
}
unset($key, $value);
?>
            ],
            xkey: 'browser',
            xLabels: 'Browser',
            ykeys: ['clicks'],
            labels: ['Clicks'],
            lineWidth: 2,
            hideHover: 'auto',
            smooth: false
        });


        /**
         * Platforms
         */


        new Morris.Bar({
            element: 'platforms_barchart',
            resize: true,
            data: [
<?php
foreach ($platforms as $key => $value) {
    echo '{platform: "' . $key . '", clicks: ' . $value . '},';
}
unset($key, $value);
?>
            ],
            xkey: 'platform',
            xLabels: 'Platform',
            ykeys: ['clicks'],
            labels: ['Clicks'],
            lineWidth: 2,
            hideHover: 'auto',
            smooth: false
        });


        /**
         * Referrers
         */

        new Morris.Bar({
            element: 'referrers_barchart',
            resize: true,
            data: [
<?php
foreach ($referrers as $key => $value) {
    echo '{referrer: "' . $key . '", clicks: ' . $value . '},';
}
unset($key, $value);
?>
            ],
            xkey: 'referrer',
            xLabels: 'Referrer',
            ykeys: ['clicks'],
            labels: ['Clicks'],
            lineWidth: 2,
            hideHover: 'auto',
            smooth: false
        });

        /**
         * Languages
         */

        new Morris.Bar({
            element: 'languages_barchart',
            resize: true,
            data: [
<?php
foreach ($languages as $key => $value) {
    echo '{language: "' . $key . '", clicks: ' . $value . '},';
}
unset($key, $value);
?>
            ],
            xkey: 'language',
            xLabels: 'Language',
            ykeys: ['clicks'],
            labels: ['Clicks'],
            lineWidth: 2,
            hideHover: 'auto',
            smooth: false
        });

        /**
         * devices Type
         */

        new Morris.Donut({
            element: 'devices_donut',
            resize: true,
            data: [
        
<?php
foreach ($devices as $key => $value) {
    echo '{label: "' . $key . '", value: ' . $value . '},';
}
unset($key, $value);
?>
            ],
            smooth: false
        });
        
        
    });



</script>

<script type="text/javascript" src="https://www.google.com/jsapi"></script>

<script type='text/javascript'>
    google.load('visualization', '1', {'packages': ['geochart']});
    google.setOnLoadCallback(drawRegionsMap);

    function drawRegionsMap() {
        var data = google.visualization.arrayToDataTable([
            ['Country', 'Clicks'],
<?php
foreach ($countries as $key => $value) {
    echo '["' . $key . '", ' . $value . '],';
}
unset($key, $value);
?>
        ]);

        var options = {};

        var chart = new google.visualization.GeoChart(document.getElementById('countries_geochart'));
        chart.draw(data, options);
    }
    ;
</script>


